function InverseMethod(block)

  setup(block);

%endfunction

function setup(block)
  
  %% Register dialog parameter: edge direction 
  %block.NumDialogPrms = 8;
  %block.DialogPrmsTunable = {'NonTunable','NonTunable','NonTunable','NonTunable','NonTunable','NonTunable','NonTunable','Tunable'};
 
  %% Register ports
  block.NumInputPorts  = 1;
  block.NumOutputPorts = 1;
  
  %% Setup port properties
  block.SetPreCompInpPortInfoToDynamic;
  %block.SetPreCompOutPortInfoToDynamic;

  block.InputPort(1).DatatypeID   = 0;
  block.InputPort(1).Complexity   = 'Real';
  block.InputPort(1).SamplingMode = 'Sample';
  
 % block.InputPort(1).DatatypeID   = 0;
  %block.InputPort(1).Complexity   = 'Real';
  %block.InputPort(1).SamplingMode = 'Sample';
  %block.InputPort(1).Overwritable = false; % No in-place operation
  
   block.OutputPort(1).DatatypeID   = 0;
   block.OutputPort(1).Complexity   = 'Real';
   block.OutputPort(1).SamplingMode = 'Sample';
   block.OutputPort(1).Dimensions   = 1;
   
   %block.OutputPort(2).DatatypeID   = 0;
   %block.OutputPort(2).Complexity   = 'Real';
   %block.OutputPort(2).SamplingMode = 'Sample';
   %block.OutputPort(2).Dimensions   = 1; 

   %block.OutputPort(3).DatatypeID   = 0;
   %block.OutputPort(3).Complexity   = 'Real';
   %block.OutputPort(3).SamplingMode = 'Sample';
   %block.OutputPort(3).Dimensions   = 1;

   %block.OutputPort(4).DatatypeID   = 0;
   %block.OutputPort(4).Complexity   = 'Real';
   %block.OutputPort(4).SamplingMode = 'Sample';
   %block.OutputPort(4).Dimensions   = 1;

%   
  %% Register block methods (through MATLAB function handles)
%  block.RegBlockMethod('Outputs', @Output);
  %block.RegBlockMethod('WriteRTW',@WriteRTW);

  %% Block runs on TLC in accelerator mode.
 % block.SetAccelRunOnTLC(true);
 block.RegBlockMethod('Outputs', @Output);
%endfunction


  
  function Output(block)
%pause(0.5)
%[block.OutputPort(1).Data , block.OutputPort(2).Data , block.OutputPort(3).Data , block.OutputPort(4).Data]= headquent(block.InputPort(1).Data , block.InputPort(2).Data,block.DialogPrm(1).Data,block.DialogPrm(2).Data,block.DialogPrm(3).Data,block.DialogPrm(4).Data,block.DialogPrm(5).Data,block.DialogPrm(6).Data,block.DialogPrm(7).Data,block.DialogPrm(7).Data);

%[block.OutputPort(1).Data , block.OutputPort(2).Data , block.OutputPort(3).Data , block.OutputPort(4).Data]= pap(block.DialogPrm(1).Data,block.DialogPrm(2).Data,block.DialogPrm(3).Data,block.DialogPrm(4).Data);
block.OutputPort(1).Data = Inverse (block.InputPort(1).Data,X,Y,Z)

%SendOSCMessage(block.DialogPrm(1).Data, block.DialogPrm(2).Data, block.DialogPrm(3).Data,  block.InputPort(1).Data )
% function [a,b,c,d]= pap(l,m,n,p)
%          
%            a= l(1,1);
% b = m(1,1);
%  c= n(1,1);
% d= p(1,1);


function [sdvisu, sdcog, sdsmcl, sdsmcr] =  Inverse(volt,X,Y,Z)

    %if click < 5
    %base=mean(volt,2); %Take off the first seconds as noise
    %save('base.mat','base'); 
    %end
    
  %base=1;  
    [nelec,npack]=size(volt)

% Lx = block.DialogPrm(1).Data;
% Ly = block.DialogPrm(2).Data;
% Lz = block.DialogPrm(3).Data;
% pG = block.DialogPrm(4).Data;

          
          
          
scl1=2.4;% scale factors
scl2=4.0; 
swhead=0;
%area 
acog=[2:8 12:18 20:26 30:36 38:44 326:332 336:342 344:350 354:360];
visu=[146:152 156:162 164:170 174:180 182:188 192:198 200:206 210:216 218:224];
smcl=[87:91 95:101 105:109 113:119 123:127];
smcr=[248:253 256:263 266:271 274:281 284:289];

	load pGFor18electrodes;
 %if mod(tatou,10)>0
    %load pG;
    %load sphlocations;
    %load base;
%     Lx = block.DialogPrm(1).Data;
%     Ly = block.DialogPrm(2).Data;
%     Lz = block.DialogPrm(3).Data;
%     pG = block.DialogPrm(4).Data;
%     base = block.DialogPrm(8).Data;
    
    data=volt-ones(nelec,npack)*mean(mean(volt))-base*ones(1,npack);
    sol=pG*data;
    mymovi4(X,Y,Z,sol)



	showme3(Lx,Ly,Lz,sol,swhead,tx2,ty2,tz2); %show the result
    sdvisu=(mean(mean(sol(visu,:)))+scl1)/scl2 % take the mean power
                                                 % and scale the data
    sdcog=(mean(mean(sol(acog,:)))+scl1)/scl2
    sdsmcl=(mean(mean(sol(smcl,:)))+scl1)/scl2
    sdsmcr=(mean(mean(sol(smcr,:)))+scl1)/scl2
    
%     sendmat(remotehost,port,'/visu','f',1,sdvisu);%send the data
%     sendmat(remotehost,port,'/cog','f',1,sdcog);
%     sendmat(remotehost,port,'/smcl','f',1,sdsmcl);
%     sendmat(remotehost,port,'/smcr','f',1,sdsmcr);    
  %else
%     base=mean(volt,2); %Take off the first seconds as noise
%     save('/export/MatCom/EEGproc/base.mat','base');
%   end  

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function F=mymovie4(x,y,z,data)
% function F=mymovie4(x,y,z,data)
% Show the data as a movie
% INPUT:
% - x,y,z: matrices of size st x sp of the dipoles location (respectively x,y,z
% coordinates)
% - data: nd x t matrix with nd number of dipoles and t number of times samples, dipoles amplitudes along the time
% OUTPUT:
% - F: matlab movie. To watch it 
%      >> h=figure('Position',[1 600 800 600])
%      >> movie(h,F,1,2) 
%      with h the handler, 1 the number of time we want to see the movie
%      and 2 the number of frame by second.
% - Display the movie on the screen during the recording

RSPH=0.075;% sphere radius

[nsol time]=size(data);
[st sp]=size(x);
F=0;
maxi=max(max(data));
mini=min(min(data));
%mov = avifile('example.avi');
Colo=zeros(st+1,sp+1);
X=zeros(st+1,sp+1);
Y=zeros(st+1,sp+1);
Z=zeros(st+1,sp+1);
X(1:st,1:sp)=x;
X(:,sp+1)=0;
X(st+1,:)=X(1,:);
Y(1:st,1:sp)=y;
Y(:,sp+1)=0;
Y(st+1,:)=Y(1,:);
Z(1:st,1:sp)=z;
Z(:,sp+1)=RSPH;
Z(st+1,:)=Z(1,:);
%figure('Position',[1 600 800 600]);
for k=1:time
  Colo(:,sp+1)=mean(data(st:st:nsol,k));  % top point
  npt=1;
  for i=0:st-1
    for j=0:sp-1        
      Colo(i+1,j+1)=data(npt,k);
      npt=npt+1;
    end
  end
  Colo(st+1,:)=Colo(1,:);

  figure(1)
  surf(X,Y,Z,Colo);
  caxis([0,2])
  shading interp
  title(['Top ',int2str(k)]);
  view(-90,90)



function showme3(x,y,z,data,head,ttx2,tty2,ttz2)
%     tx2 = block.DialogPrm(5).Data;
%     ty2 = block.DialogPrm(6).Data;
%     tz2 = block.DialogPrm(7).Data;
% function showme2(x,y,z,data,head)
% uses Matlab surf function to show the data
% data has to be adapted to correspond to x,y,z position
% x,y,z have been writted using sphreg2.m
% INPUT:
% - x,y,z : (sp+1) x (st+1) matrices with point coordinates
% - data: data to show
% - head: binary value, if 1: show an head contour in the graph
% OUTPUT:
% - a colored figure of the data

[ta tb]=size(x);
st=ta-1;
sp=tb-1;
Colo=zeros(st+1,sp+1);
Colo(:,sp+1)=data(1); % first position of the data corresponds to top point
npt=1;
for i=0:st-1
  for j=0:sp-1
    if j>sp-3 & mod(i+1,2)==0 % two last lines are subsampled
      Colo(i+1,j+1)=Colo(i,j+1);
    else
      npt=npt+1;
      Colo(i+1,j+1)=data(npt);
    end
  end
end
Colo(st+1,:)=Colo(1,:);

%figure;
% head contour
if head
  load headcontour;
 plot3(ttx2,tty2,ttz2);
 hold on
end

surf(x,y,z,Colo);
%caxis([-12 16]);
shading interp
view(-90,90)
%end %showme3


